* oneway_power2.sas;
options pageno=1 linesize=80;
goptions reset=all;
title 'Power Analysis for One-Way ANOVA';
proc power;
	ods output Plotcontent=plotdata;
	onewayanova
		groupmeans = (20 22 22 25 18)
		stddev = 3 6
		alpha = 0.05 0.01
		npergroup = 2 to 20 by 1
		power = . ;
	plot x=n;
run;
* Plot power vs. sample size in a nicer graph;
proc gplot data=plotdata;
	plot power*npergroup=plotcurve / vaxis=axis1 haxis=axis1 legend=legend1;
	symbol1 i=join v=circle c=black width=3 height=2;
	symbol2 i=join v=plus c=black width=3 height=2;
	symbol3 i=join v=circle c=black l=2 width=3 height=2;
	symbol4 i=join v=plus c=black l=2 width=3 height=2;
	axis1 label=(height=2) value=(height=2) width=3 major=(width=2) minor=none;
	legend1 label=(height=2) value=(height=2);
run;
quit;


